<?php

// Funciones para consumir con CURL el REST-API

function request($auth, $url, $http_method = NULL, $data = NULL) {
        
        //check to see if we have curl installed on the server 
        if (!extension_loaded('curl')) {
            //no curl
            die('The cURL extension is required');
        }

        //init the curl request
        //via endpoint to curl
        $req = curl_init($url);
        
        //set request headers
        /*
        curl_setopt($req, CURLOPT_HTTPHEADER, array(
            'Authorization: Basic ' . $auth,
            'Accept: application/xml',
            'Content-Type: application/x-www-form-urlencoded',
        ));
        */        

        //set other curl options        
        curl_setopt($req, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($req, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($req, CURLOPT_TIMEOUT, 30);


        //set http method
        //default to GET if data is null
        //default to POST if data is not null
        if (is_null($http_method)) {
            if (is_null($data)) {
                $http_method = 'GET';
            } else {
                $http_method = 'POST';
            }
        }

        //set http method in curl
        curl_setopt($req, CURLOPT_CUSTOMREQUEST, $http_method);

        //make sure incoming payload is good to go, set it
        if (!is_null($data)) {
            if (is_array($data)) {
                $raw = http_build_query($data);
            } else {
                //Incase of raw xml
                $raw = $data;
            }
            curl_setopt($req, CURLOPT_POSTFIELDS, $raw);
        }

        //execute curl request
        $raw = curl_exec($req);

        if (false === $raw) { //make sure we got something back
            die(curl_error($req) . $url);
        }

        //decode the result
        $res = json_decode($raw);
        if (is_null($res)) { //make sure the result is good to go
        
            $content  = curl_exec($req);
            
            die($content.' - Unexpected response format ->  ' . $url);
        }

        return $res;
    }

?>